/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserInteractionRegistry;
import com.aptana.portal.ui.dispatch.browserNotifications.AbstractBrowserNotification;
import com.aptana.portal.ui.internal.BrowserWrapper;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserNotifier {
    private static final String NOTIFICATION_PATTERN = "if (typeof(eventsDispatcher) !== 'undefined') eventsDispatcher.notify(''{0}'');";
    private static final String DATA_PATTERN_PREFIX = "\"data\":";
    private static BrowserNotifier instance = null;
    private Map<String, BrowserWrapper> browsers = new HashMap<String, BrowserWrapper>();

    private BrowserNotifier() {
    }

    public static BrowserNotifier getInstance() {
        if (instance == null) {
            instance = new BrowserNotifier();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBrowser(final String id, BrowserWrapper browser) {
        if (!browser.isDisposed()) {
            Map<String, BrowserWrapper> map = this.browsers;
            synchronized (map) {
                this.browsers.put(id, browser);
                browser.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        BrowserNotifier.this.unregisterBrowser(id);
                    }
                });
                if (this.browsers.size() == 1) {
                    this.startNotifiers();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBrowser(String id) {
        Map<String, BrowserWrapper> map = this.browsers;
        synchronized (map) {
            this.browsers.remove(id);
            if (this.browsers.size() == 0) {
                this.stopNotifiers();
            }
        }
    }

    public static String toJSONNotification(String eventName, String eventType, String eventData) {
        LinkedHashMap<String, String> event = new LinkedHashMap<String, String>();
        event.put("event", eventName);
        event.put("eventType", eventType);
        event.put("data", "");
        String json = JSON.toString(event);
        if (eventData != null) {
            json = json.replaceAll("\"data\":\"\"", DATA_PATTERN_PREFIX + eventData);
        }
        return json;
    }

    public static String toJSONErrorNotification(String errorType, String detailedMessage) {
        String json = null;
        if (detailedMessage == null) {
            json = BrowserNotifier.toJSONNotification("error", errorType, null);
        } else {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("errorDetails", detailedMessage);
            json = BrowserNotifier.toJSONNotification("error", errorType, JSON.toString(error));
        }
        return json;
    }

    public static String createBrowserNotification(String eventName, String eventType, String eventData) {
        String json = BrowserNotifier.toJSONNotification(eventName, eventType, eventData);
        return MessageFormat.format(NOTIFICATION_PATTERN, json);
    }

    public boolean notifyBrowser(BrowserWrapper browser, String eventName, String eventType, String eventData) {
        String notification = BrowserNotifier.createBrowserNotification(eventName, eventType, eventData);
        return browser.execute(notification);
    }

    public boolean notifyBrowser(List<String> notificationTargets, String eventName, String eventType, String eventData) {
        String notification = BrowserNotifier.createBrowserNotification(eventName, eventType, eventData);
        IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)("Notifying the portal with: " + notification), (String)"com.aptana.portal.ui/debug/startpage");
        boolean notifyAll = notificationTargets.isEmpty();
        boolean result = true;
        for (String id : this.browsers.keySet()) {
            BrowserWrapper b;
            if (!notifyAll && !notificationTargets.contains(id) || (b = this.browsers.get(id)).isDisposed()) continue;
            result &= b.execute(notification);
        }
        return result;
    }

    public void notifyBrowserInUIThread(final List<String> notificationTargets, final String eventName, final String eventType, final String eventData) {
        UIJob uiJob = new UIJob("Browser Notify"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BrowserNotifier.this.notifyBrowser(notificationTargets, eventName, eventType, eventData);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)uiJob);
        uiJob.schedule();
    }

    protected void startNotifiers() {
        AbstractBrowserNotification[] notifications;
        AbstractBrowserNotification[] abstractBrowserNotificationArray = notifications = BrowserInteractionRegistry.getInstance().getBrowserNotifications();
        int n = notifications.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBrowserNotification notification = abstractBrowserNotificationArray[n2];
            notification.start();
            ++n2;
        }
    }

    protected void stopNotifiers() {
        AbstractBrowserNotification[] notifications;
        AbstractBrowserNotification[] abstractBrowserNotificationArray = notifications = BrowserInteractionRegistry.getInstance().getBrowserNotifications();
        int n = notifications.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBrowserNotification notification = abstractBrowserNotificationArray[n2];
            notification.stop();
            ++n2;
        }
    }
}

